package w83a.w83aOperacionesPaso.w83aResultados;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;

import w83a.w83aBeans.W83aResultadosBean;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aUtilidades.W83aUtilidadesComunes;
import w83a.w83aUtilidades.W83aUtilidadesPdf;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aDateUtil;
import w83a.w83aUtilidadesComunes.W83aUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83aTablaCuadroResultadosClasifPdfAction extends Q70ActionPasoOP{
	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        
        Map mapaMenorIgual49 = (HashMap)contexto.get("w83aMapResMenorIgual49Bean");
        Map mapaMayor49 = (HashMap)contexto.get("w83aMapResMayor49Bean");
        Map cab = (HashMap)contexto.get("w83aMapCabeceraResultadosBean");
        W83aResultadosBean resultadoBean = (W83aResultadosBean)contexto.get("w83aResultadosBean");
        W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        //String provincia = W83aUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets()); 
        String provincia = usuario.getCodTerritorioDelegacion(); 
        String idioma = (String)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
     
        Map listaHasta49=new HashMap();
        Map listaMas49=new HashMap();
        
        Document document = new Document();	
        if (!"0".equals(resultadoBean.getTerritorio())){
        	document = new Document(PageSize.A4); //Creo un documento 	
        }
        else{
        	document = new Document(PageSize.A4.rotate()); //Creo un documento 	
        }
				
		document.setMargins(30, 30, 80, 40);	
	    
		PdfWriter.getInstance(document, response.getOutputStream());		
		response.setContentType("application/pdf");		
    	response.setHeader("Content-Disposition", "attachment;filename=CuadroResumenResultados.pdf;");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        response.setStatus(HttpServletResponse.SC_OK);
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance(document, baos);
        
        Rectangle rct;
        if (!"0".equals(resultadoBean.getTerritorio())){
        	rct = new Rectangle(36, 40, 589, 788);
        }
        else{
        	rct = new Rectangle(54, 36, 788 , 589);
        }
	    writer.setBoxSize("art", rct); 	
        
        W83aUtilidadesPdf.HeaderFooter event = new W83aUtilidadesPdf.HeaderFooter(idioma, usuario.getCalleListadosFormateada());
        writer.setPageEvent(event);
        
        document.open();
        if (!"0".equals(resultadoBean.getTerritorio())){
    	   listaHasta49=new TreeMap((Map)mapaMenorIgual49.get(resultadoBean.getTerritorio()+"|menos49"));
           listaMas49=new TreeMap((Map)mapaMayor49.get(resultadoBean.getTerritorio()+"|mas49"));
    	   if (listaHasta49.size()>0&&listaMas49.size()==0){
           		//Crear una hoja-->
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramenos49"),(Map)listaHasta49.get("sindicatos"),"menos",0,document,idioma,"unterrit");
           		crearcontenidoterritorio(document,idioma,(Map)listaHasta49.get("sindicatos"),resultadoBean.getPorcentaje());
    	   }else if(listaHasta49.size()==0&&listaMas49.size()>0){
    		    //Crear una hoja-->
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramas49"),(Map)listaMas49.get("sindicatos"),"mas",0,document,idioma,"unterrit");
           		crearcontenidoterritorio(document,idioma,(Map)listaMas49.get("sindicatos"),resultadoBean.getPorcentaje());
    	   }else{
    		    //Crear dos hojas-->
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramenos49"),(Map)listaHasta49.get("sindicatos"),"menos",0,document,idioma,"unterrit");
           		crearcontenidoterritorio(document,idioma,(Map)listaHasta49.get("sindicatos"),resultadoBean.getPorcentaje());
           		document.newPage();
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramas49"),(Map)listaMas49.get("sindicatos"),"mas",1,document,idioma,"unterrit");
           		crearcontenidoterritorio(document,idioma,(Map)listaMas49.get("sindicatos"),resultadoBean.getPorcentaje());
    	   }	
        }else{
        	listaHasta49=new TreeMap((Map)mapaMenorIgual49.get("todos|menos49"));
            listaMas49=new TreeMap((Map)mapaMayor49.get("todos|mas49"));
            if (listaHasta49.size()>0&&listaMas49.size()==0){
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramenos49"),(Map)listaHasta49.get("sindicatos"),"menos",0,document,idioma,"territs");
           		crearcontenidotodos(document,idioma,(Map)listaHasta49.get("sindicatos"),resultadoBean.getPorcentaje());
            }else if(listaHasta49.size()==0&&listaMas49.size()>0){
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramas49"),(Map)listaMas49.get("sindicatos"),"mas",0,document,idioma,"territs");
           		crearcontenidotodos(document,idioma,(Map)listaMas49.get("sindicatos"),resultadoBean.getPorcentaje());
            }else{
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramenos49"),(Map)listaHasta49.get("sindicatos"),"menos",0,document,idioma,"territs");
           		crearcontenidotodos(document,idioma,(Map)listaHasta49.get("sindicatos"),resultadoBean.getPorcentaje());
           		document.newPage();
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramas49"),(Map)listaMas49.get("sindicatos"),"mas",1,document,idioma,"territs");
            	crearcontenidotodos(document,idioma,(Map)listaMas49.get("sindicatos"),resultadoBean.getPorcentaje());
            }	
        }
       document.close();
       if (!"0".equals(resultadoBean.getTerritorio())){
    	   W83aUtilidadesPdf.ponerCabecera(baos,provincia,idioma,"vertical");
       }
       else{
    	   W83aUtilidadesPdf.ponerCabecera(baos,provincia,idioma,"horizontal");
       }
       
	   OutputStream out = response.getOutputStream();	        
	   baos.writeTo(out);
	   out.flush();			
	   out.close();
		
	   return null;
	}

	private void crearcabecera(Q70ContextoEJIE contexto, String domicilio,W83aResultadosBean resultadoBean, List cabecera, Map m, String literal, int s,Document document,String idioma, String territ) throws Exception{//NOPMD
		Font fonttitulo = FontFactory.getFont("Arial", 12, Font.BOLD);
		Font fontnormal = FontFactory.getFont("Arial", 9, Font.NORMAL);
		Font fontnormalpeq = FontFactory.getFont("Arial", 8, Font.NORMAL);
        
		Paragraph parrafo;
        parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloCuadroResultadosClasif_eu",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloCuadroResultadosClasif_es",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fonttitulo);
        parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        document.add(parrafo);
   
        if ("0".equals(resultadoBean.getTerritorio())){	
        	parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.comautvascaentero",idioma)+" - "+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}),fontnormalpeq);      			
		}
        else{
        	parrafo=new Paragraph(resultadoBean.getDescTerritorio().toUpperCase()+" - "+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}),fontnormalpeq);
        	
        }
		parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        document.add(parrafo);
        PdfPTable table;
        PdfPCell cell;
        table=new PdfPTable(4);
        table.setWidthPercentage(100);  
        float[] columnWidths = {0.5f,2f,2f,1f};
        table.setWidths(columnWidths);
        cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
        if(resultadoBean.getPorcentaje()!=null && !"".equals(resultadoBean.getPorcentaje())){
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.porcentajeSobreTotal",idioma)+": "+resultadoBean.getPorcentaje()+"%",fontnormalpeq));
        	cell.setBorder(0);
        	table.addCell(cell); 
        }   
        else{
        	cell = new PdfPCell(new Phrase(""));
        	cell.setBorder(0);
        	table.addCell(cell); 
        }
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.clasificarnumtrab",idioma),fontnormalpeq));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.si",idioma),fontnormalpeq));
    	cell.setBorder(0);
    	table.addCell(cell);
    	document.add(table);
       
        table=new PdfPTable(2);
        table.setWidthPercentage(100);       
        columnWidths = new float[]{4f, 1f};
        table.setWidths(columnWidths);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.datosgenerales",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(resultadoBean.getFechaRegistroDefinitivo(),idioma), idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell); 
    	document.add(table);
    	
        table=new PdfPTable(6);
        table.setWidthPercentage(100); 
        columnWidths = new float[]{2f, 1f, 2f, 1f, 2f, 1f};
        table.setWidths(columnWidths);
        int numempresas=cabecera.size();
        int numcentros=0;
        int numvotos=0;
        int totalelectores=0;
        int hasta49=0;
        int masde49=0;
        for (int i=0;i<cabecera.size();i++){
        	numcentros=numcentros+Integer.parseInt(((W83aResultadosBean)cabecera.get(i)).getNumcentros());
        	numvotos=numvotos+Integer.parseInt(((W83aResultadosBean)cabecera.get(i)).getTotalvotos());
        	totalelectores=totalelectores+Integer.parseInt(((W83aResultadosBean)cabecera.get(i)).getNumTrabajadores());
        }
        
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numempresas",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(numempresas),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numcentros",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(numcentros),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalelectores",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalelectores),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalvotantes",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(numvotos),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.porcentaje",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aUtilidades.calcularporcentajePdf(numvotos,totalelectores),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  

    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numdeleg",idioma),fontnormal));
    	cell.setBorder(0);
    	cell.setColspan(6);
    	table.addCell(cell);
        Iterator it;
        if ("unterrit".equals(territ)){
        	if ("menos".equals(literal)){
        		Set ref = m.keySet();
        		 for( it = ref.iterator(); it.hasNext();) {
        			String a=(String)it.next();
                	Map c=(HashMap)m.get(a);
                	if (c!=null){
                		if (c.get("F")!=null){
                			hasta49=hasta49+Integer.parseInt((String)c.get("F"));
                		}
                		if (c.get("L")!=null){
                			hasta49=hasta49+Integer.parseInt((String)c.get("L"));
                		}
                	}
                }
        	    cell = new PdfPCell(new Phrase("",fontnormal));
        	    cell.setBorder(0);
        	    table.addCell(cell);
        		cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.hasta49",idioma),fontnormal));
        	    cell.setBorder(0);
        	    table.addCell(cell);
        	    cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(hasta49),fontnormal));
        	    cell.setBorder(0);
        	    table.addCell(cell);
        		cell = new PdfPCell(new Phrase("",fontnormal));
        	    cell.setBorder(0);
        	    table.addCell(cell);
        	    cell = new PdfPCell(new Phrase("",fontnormal));
              	cell.setBorder(0);
              	table.addCell(cell);
              	cell = new PdfPCell(new Phrase("",fontnormal));
              	cell.setBorder(0);
              	table.addCell(cell);
            }
            if ("mas".equals(literal)){
            	Set ref = m.keySet();
       		 	for( it = ref.iterator(); it.hasNext();) {
       		 		String a=(String)it.next();
       		 		Map c=(HashMap)m.get(a);
                	if (c!=null){
                		if (c.get("F")!=null){
                			masde49=masde49+Integer.parseInt((String)c.get("F"));
                		}
                		if (c.get("L")!=null){
                			masde49=masde49+Integer.parseInt((String)c.get("L"));
                		}
                	}
                }
       		 	cell = new PdfPCell(new Phrase("",fontnormal));
       		 	cell.setBorder(0);
       		 	table.addCell(cell);
       		 	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.demasde49",idioma),fontnormal));
       		 	cell.setBorder(0);
       		    cell.setColspan(2);
       		 	table.addCell(cell);
       		 	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(masde49),fontnormal));
       		 	cell.setBorder(0);
       		    table.addCell(cell);
       			cell = new PdfPCell(new Phrase("",fontnormal));
        	    cell.setBorder(0);
        	    table.addCell(cell);
        	    cell = new PdfPCell(new Phrase("",fontnormal));
              	cell.setBorder(0);
              	table.addCell(cell);
            } 
        }
        else{
        	if ("menos".equals(literal)){
        		Set ref = m.keySet();
       		 	for( it = ref.iterator(); it.hasNext();) {
       		 		String a=(String)it.next();
       		 		Map c=(HashMap)m.get(a);
                	if (c!=null){
                		if (c.get("F")!=null){
                			Map t=(Map)c.get("F");
                			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
                			}
                		}
                		if (c.get("L")!=null){
                			Map t=(Map)c.get("L");
                			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
                			}
                		}
                	}
                }
         	 cell = new PdfPCell(new Phrase("",fontnormal));
         	 cell.setBorder(0);
         	 table.addCell(cell);	
       		 cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.hasta49",idioma),fontnormal));
     	     cell.setBorder(0);
     	     table.addCell(cell);
     	     cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(hasta49),fontnormal));
     	     cell.setBorder(0);
     	     table.addCell(cell);
     	     cell = new PdfPCell(new Phrase("",fontnormal));
          	 cell.setBorder(0);
          	 table.addCell(cell);
          	 cell = new PdfPCell(new Phrase("",fontnormal));
          	 cell.setBorder(0);
          	 table.addCell(cell);
          	 cell = new PdfPCell(new Phrase("",fontnormal));
          	 cell.setBorder(0);
          	 table.addCell(cell);
            }
            if ("mas".equals(literal)){
            	Set ref = m.keySet();
       		 	for( it = ref.iterator(); it.hasNext();) {
       		 		String a=(String)it.next();
       		 		Map c=(HashMap)m.get(a);
                	if (c!=null){
                		if (c.get("F")!=null){
                			Map t=(Map)c.get("F");
                			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
                			}
                		}
                		if (c.get("L")!=null){
                			Map t=(Map)c.get("L");
                			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
                			}
                		}
                	}
                }
       		 	cell = new PdfPCell(new Phrase("",fontnormal));
       		 	cell.setBorder(0);
       		 	table.addCell(cell);
       		    cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.demasde49",idioma),fontnormal));
    		 	cell.setBorder(0);
    		 	table.addCell(cell);
    		 	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(masde49),fontnormal));
    		 	cell.setBorder(0);
    		 	table.addCell(cell);
    		 	cell = new PdfPCell(new Phrase("",fontnormal));
        	    cell.setBorder(0);
        	    table.addCell(cell);
        	    cell = new PdfPCell(new Phrase("",fontnormal));
              	cell.setBorder(0);
              	table.addCell(cell);
              	cell = new PdfPCell(new Phrase("",fontnormal));
              	cell.setBorder(0);
              	table.addCell(cell);
            } 
        }
      
        document.add(table);
        parrafo=new Paragraph("*"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.rescentrales",idioma)+"*",fontnormal);
        parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        document.add(parrafo);
	}
	
	private void crearcontenidoterritorio(Document document,String idioma,Map m,String porcentaje) throws Q70GestorMensajesException{
		Font fontnormal = FontFactory.getFont("Arial", 9, Font.NORMAL);
		Font fontnormalpeq = FontFactory.getFont("Arial", 8, Font.NORMAL);
		PdfPTable table;
        PdfPCell cell;
		table=new PdfPTable(7);
        table.setWidthPercentage(100); 
        float[]columnWidths = {1f, 5f, 1f, 1f, 1f, 1f, 1f};
        try {
			table.setWidths(columnWidths);
		} catch (DocumentException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
        cell = new PdfPCell(new Phrase("",fontnormal));
        cell.setColspan(3);
        cell.setBorder(0);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(String.valueOf(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.representantes",idioma).toUpperCase()),fontnormal));
        cell.setColspan(3);
        cell.setBorder(0);
        cell.setBorder(Rectangle.BOTTOM);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
     	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.central",idioma),fontnormal));
    	cell.setColspan(3);
    	cell.setBorder(0);
    	cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.func",idioma),fontnormal));
        cell.setBorder(0);
        cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.labo",idioma),fontnormal));
        cell.setBorder(0);
        cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma),fontnormal));
        cell.setBorder(0);
        cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","%",idioma),fontnormal));
        cell.setBorder(0);
        cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        
        String[] valores;
      
        Iterator it = m.entrySet().iterator();
        int numdelegadostotal=0;
        int cont=0;
        SortedMap map = new TreeMap(java.util.Collections.reverseOrder());
        int suma=0;
        while (it.hasNext()) {
        	suma=0;
        	cont++;
        	Map.Entry e = (Map.Entry)it.next();
        	Map c=(HashMap)e.getValue();
        	String a=(String)e.getKey();
        	
        	if (c!=null){
        		if (c.get("F")!=null){
		            numdelegadostotal=numdelegadostotal+Integer.parseInt((String)c.get("F"));
		            suma=suma+Integer.parseInt((String)c.get("F"));
        		}
        		if (c.get("L")!=null){
        			numdelegadostotal=numdelegadostotal+Integer.parseInt((String)c.get("L"));
        			suma=suma+Integer.parseInt((String)c.get("L"));
        		}
        	}
        	 map.put(W83aUtilidadesComunes.rellenarCeros(String.valueOf(suma))+"#"+String.valueOf(cont),a);
        }
        int numdelegadospubl=0;
        int numdelegadospriv=0;
       
        Double porcentajeFiltro=new Double(0.0);
        if(StringUtils.isNotEmpty(porcentaje)){
        	String porc=porcentaje.replace(',','.');
    		porcentajeFiltro = new Double(porc);
        }
        int delegados=0;
        int func=0;
        int labo=0;
        int tot=0;
        
        boolean otros=false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
	        Object key = iterator.next();
	        String valorClave=(String)map.get(key);
        	int numdelegados=0;
        	int numdelegadospu=0;
        	int numdelegadospr=0;
            valores=valorClave.split("\\|");
            Map c=(HashMap)m.get(valorClave);
            if (c!=null){
        		if (c.get("L")!=null){
        			numdelegados=numdelegados+Integer.parseInt((String)c.get("L"));
		            numdelegadospriv=numdelegadospriv+numdelegados;
		            numdelegadospr=Integer.parseInt((String)c.get("L"));
        		}
        		if (c.get("F")!=null){
        		    numdelegados=Integer.parseInt((String)c.get("F"));
		            numdelegadospubl=numdelegadospubl+numdelegados;
		            numdelegadospu=Integer.parseInt((String)c.get("F"));
        		}
        		
        	}
          //debemos mirar  si el % supera el que hemos puesto, para ponerlo en otros
    		if(StringUtils.isNotEmpty(porcentaje)&&W83aUtilidades.porcentaje(numdelegadospr+numdelegadospu,numdelegadostotal)*100<porcentajeFiltro.floatValue()){
    			delegados=delegados+numdelegadospr+numdelegadospu;
    			if (c.get("F")!=null){
	            	func=func+Integer.parseInt((String)c.get("F"));
	            	}
	            	if (c.get("L")!=null){
	            	labo=labo+Integer.parseInt((String)c.get("L"));
	            	}
	            	tot=tot+numdelegadospu+numdelegadospr;
    			otros=true;
    		}
    		else{
            
	            if ("null".equals(valores[0])||valores[0]==null){
	            	cell = new PdfPCell(new Phrase(""));//NOPMD
	            }
	            else{
	            	cell = new PdfPCell(new Phrase(valores[0],fontnormalpeq));//NOPMD
	            }
	            cell.setBorder(0);
                table.addCell(cell);
	            if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
	            	if ("null".equals(valores[1])||valores[1]==null){
	            		cell = new PdfPCell(new Phrase(""));//NOPMD
	            	}
	            	else{
	            		cell = new PdfPCell(new Phrase(valores[1],fontnormalpeq));//NOPMD
	            	}
	            }
	            else{
	            	if ("null".equals(valores[2])||valores[2]==null){
	            		cell = new PdfPCell(new Phrase(""));//NOPMD
	            	}
	            	else{
	            		cell = new PdfPCell(new Phrase(valores[2],fontnormalpeq));//NOPMD
	            	}
	            }
	            cell.setBorder(0);
                table.addCell(cell);
                cell = new PdfPCell(new Phrase(""));//NOPMD
                cell.setBorder(0);
                table.addCell(cell);
	            //Convenios	        	
	        	if (c!=null){
	        		if (c.get("F")!=null){
	        			cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(Integer.parseInt(String.valueOf(c.get("F")))),fontnormalpeq));//NOPMD
	         			cell.setBorder(0);
	         			cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		                table.addCell(cell);
			        }
	        		else{
	         			cell = new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
		                cell.setBorder(0);
		                cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		                table.addCell(cell);
	         		}
	        		if (c.get("L")!=null){
	        			cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(Integer.parseInt(String.valueOf(c.get("L")))),fontnormalpeq));//NOPMD
		                cell.setBorder(0);
		                cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		                table.addCell(cell);
	        		}
	        		else{
	         			cell = new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
		                cell.setBorder(0);
		                cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		                table.addCell(cell);
	         		}
	        	}
	        	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(numdelegadospu+numdelegadospr),fontnormalpeq));//NOPMD
                cell.setBorder(0);
                cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                table.addCell(cell);
                cell = new PdfPCell(new Phrase(W83aUtilidades.calcularporcentajePdf(numdelegadospu+numdelegadospr,numdelegadostotal),fontnormalpeq));//NOPMD
                cell.setBorder(0);
                cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                table.addCell(cell);
    		}
        }
        if(otros){
        	cell = new PdfPCell(new Phrase(""));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase(),fontnormalpeq));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(""));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(func),fontnormalpeq));
            cell.setBorder(0);
            cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(labo),fontnormalpeq));
            cell.setBorder(0);
            cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(tot),fontnormalpeq));
            cell.setBorder(0);
            cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
            table.addCell(cell);
     	    cell=new PdfPCell(new Phrase(W83aUtilidades.calcularporcentajePdf(delegados,numdelegadostotal),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
            table.addCell(cell);
        }
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",idioma).toUpperCase(),fontnormalpeq));
        cell.setBorder(0);
        cell.setBorder(Rectangle.TOP);
        table.addCell(cell); 
        cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        cell.setBorder(Rectangle.TOP);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        cell.setBorder(Rectangle.TOP);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(numdelegadospubl),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
 	    cell.setBorder(Rectangle.TOP);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(numdelegadospriv),fontnormalpeq));            
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.TOP);
 	    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(numdelegadospubl+numdelegadospriv),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.TOP);
 	    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
			try {
				document.add(table);
			} catch (DocumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
	}
	
	private void crearcontenidotodos(Document document,String idioma,Map m,String porcentaje) throws Q70GestorMensajesException{
		Font fontnormalpeq = FontFactory.getFont("Arial", 8, Font.NORMAL);
		Double porcentajeFiltro=new Double(0.0);
        if(StringUtils.isNotEmpty(porcentaje)){
        	String porc=porcentaje.replace(',','.');
    		porcentajeFiltro = new Double(porc);
        }
        PdfPTable table;
        PdfPCell cell;
        table=new PdfPTable(17);
        table.setWidthPercentage(100); 
        cell=new PdfPCell(new Phrase(""));
        cell.setColspan(2);
 	    cell.setBorder(0);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.araba",idioma),fontnormalpeq));
 	    cell.setBorder(0);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(""));
        cell.setColspan(3);
 	    cell.setBorder(0);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.bizkaia",idioma),fontnormalpeq));
 	    cell.setBorder(0);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(""));
        cell.setColspan(3);
 	    cell.setBorder(0);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.gipuzkoa",idioma),fontnormalpeq));
 	    cell.setBorder(0);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(""));
        cell.setColspan(3);
 	    cell.setBorder(0);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.comautvasca",idioma),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setColspan(3);
        table.addCell(cell);
        
        cell=new PdfPCell(new Phrase(""));;
 	    cell.setBorder(0);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase(),fontnormalpeq));
        cell.setColspan(2);
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(""));
        cell.setColspan(2);
 	    cell.setBorder(0);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase(),fontnormalpeq));
        cell.setColspan(2);
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(""));
        cell.setColspan(2);
 	    cell.setBorder(0);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase(),fontnormalpeq));
        cell.setColspan(2);
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(""));
        cell.setColspan(2);
 	    cell.setBorder(0);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase(),fontnormalpeq));
        cell.setColspan(2);
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(""));
        cell.setColspan(2);
 	    cell.setBorder(0);
        table.addCell(cell);
        
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.central",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase("%",fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase("%",fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase("%",fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        cell=new PdfPCell(new Phrase("%",fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.BOTTOM);
        table.addCell(cell);
        
        Iterator it;
        Set ref = m.keySet();
		int ntpa=0;
		int ntpb=0;
		int ntpra=0;
		int ntprb=0;
		int ntpg=0;
		int ntprg=0;
		int nt=0;
		int cont=0;
		int suma=0;
        SortedMap map = new TreeMap(java.util.Collections.reverseOrder());
		for( it = ref.iterator(); it.hasNext();) {
			suma=0;
			cont++;
			String a=(String)it.next();
            Map c=(HashMap)m.get(a);
            if (c!=null){
            	if (c.get("F")!=null){
        			Map t=(Map)c.get("F");
        			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
        				ntpa=ntpa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
        				ntpb=ntpb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
        				ntpg=ntpg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        			}
        		}
        		if (c.get("L")!=null){
        			Map t=(Map)c.get("L");
        			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
        				ntpra=ntpra+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
        				ntprb=ntprb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
        				ntprg=ntprg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        			}
        		}
        		
            }
            nt=ntpa+ntpb+ntpg+ntpra+ntprb+ntprg;
            map.put(W83aUtilidadesComunes.rellenarCeros(String.valueOf(suma))+"#"+String.valueOf(cont),a);
        }
		ref = m.keySet();
		String[] valores;
		int numdelegadospublal=0;
		int numdelegadospublbi=0;
		int numdelegadospublgi=0;
		int numdelegadosprival=0;
		int numdelegadosprivbi=0;
		int numdelegadosprivgi=0;
		int numdelegadostotpublal=0;
		int numdelegadostotpublbi=0;
		int numdelegadostotpublgi=0;
		int numdelegadostotprival=0;
		int numdelegadostotprivbi=0;
		int numdelegadostotprivgi=0;
		int numdelegadospublalpor=0;
		int numdelegadospublbipor=0;
		int numdelegadospublgipor=0;
		int numdelegadosprivalpor=0;
		int numdelegadosprivbipor=0;
		int numdelegadosprivgipor=0;
		int numdelegadostotpublalpor=0;
		int numdelegadostotpublbipor=0;
		int numdelegadostotpublgipor=0;
		int numdelegadostotprivalpor=0;
		int numdelegadostotprivbipor=0;
		int numdelegadostotprivgipor=0;
		boolean otros=false;
		Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
	        Object key = iterator.next();
	        String valorClave=(String)map.get(key);
        	numdelegadospublal=0;
    		numdelegadospublbi=0;
    		numdelegadospublgi=0;
    		numdelegadosprival=0;
    		numdelegadosprivbi=0;
    		numdelegadosprivgi=0;
    		
            valores=valorClave.split("\\|");
            int nuestroalava=0;
            int nuestrovizcaya=0;
            int nuestroguipuzcoa=0;
            //sumamos los valores para calcular el %
            Map c=(HashMap)m.get(valorClave);
            if (c!=null){
            	if (c.get("F")!=null){
        			Map t=(Map)c.get("F");
        			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
        				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
        				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
        				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        			}
        		}
        		if (c.get("L")!=null){
        			Map t=(Map)c.get("L");
        			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
        				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
        				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
        				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        			}
        		}
            }
            //comprobamos que el % de nuestros valores supere o no el porcentaje
            if(StringUtils.isNotEmpty(porcentaje)&&W83aUtilidades.porcentaje(nuestroalava+nuestrovizcaya+nuestroguipuzcoa,nt)*100<porcentajeFiltro.floatValue()){
            	if (c!=null){
                	if (c.get("F")!=null){
            			Map t=(Map)c.get("F");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				numdelegadospublal=numdelegadospublal+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            				numdelegadospublalpor=numdelegadospublalpor+numdelegadospublal;
            				numdelegadostotpublal=numdelegadostotpublal+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            				numdelegadostotpublalpor=numdelegadostotpublalpor+numdelegadostotpublal;
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				numdelegadospublbi=numdelegadospublbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            				numdelegadospublbipor=numdelegadospublbipor+numdelegadospublbi;
            				numdelegadostotpublbi=numdelegadostotpublbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            				numdelegadostotpublbipor=numdelegadostotpublbipor+numdelegadostotpublbi;
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				numdelegadospublgi=numdelegadospublgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            				numdelegadospublgipor=numdelegadospublgipor+numdelegadospublgi;
            				numdelegadostotpublgi=numdelegadostotpublgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            				numdelegadostotpublgipor=numdelegadostotpublgipor+numdelegadostotpublgi;
            			}
            		}
            		if (c.get("L")!=null){
            			Map t=(Map)c.get("L");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				numdelegadosprival=numdelegadosprival+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            				numdelegadosprivalpor=numdelegadosprivalpor+numdelegadosprival;
            				numdelegadostotprival=numdelegadostotprival+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            				numdelegadostotprivalpor=numdelegadostotprivalpor+numdelegadostotprival;
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				numdelegadosprivbi=numdelegadosprivbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            				numdelegadosprivbipor=numdelegadosprivbipor+numdelegadosprivbi;
            				numdelegadostotprivbi=numdelegadostotprivbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            				numdelegadostotprivbipor=numdelegadostotprivbipor+numdelegadostotprivbi;
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				numdelegadosprivgi=numdelegadosprivgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            				numdelegadosprivgipor=numdelegadosprivgipor+numdelegadosprivgi;
            				numdelegadostotprivgi=numdelegadostotprivgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            				numdelegadostotprivgipor=numdelegadostotprivgipor+numdelegadostotprivgi;
            			}
            		}
                }
            	otros=true;
            }
            else{
            //cuando nuestros valores superan el porcentaje
	            if ("null".equals(valores[0])||valores[0]==null){
	            	cell=new PdfPCell(new Phrase(""));//NOPMD
	         	    cell.setBorder(0);
	                table.addCell(cell);
	            }
	            else{
	            	cell=new PdfPCell(new Phrase(valores[0],fontnormalpeq));//NOPMD
	         	    cell.setBorder(0);
	                table.addCell(cell);
	            }
	            if (c!=null){
	            	if (c.get("F")!=null){
	            		Map t=(Map)c.get("F");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA))){
            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
            				}
            				else{
            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA),fontnormalpeq));//NOPMD
            				}		
            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
    		         	    cell.setBorder(0);
    		                table.addCell(cell);
    		                numdelegadospublal=numdelegadospublal+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	        				numdelegadostotpublal=numdelegadostotpublal+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
            			}
            			else{
            				celdaCero(cell,table,fontnormalpeq);
            			}
	            	}
	            	else{
	            		celdaCero(cell,table,fontnormalpeq);
	            	}
            		if (c.get("L")!=null){
            			Map t=(Map)c.get("L");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA))){
            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
            				}
            				else{
            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA),fontnormalpeq));//NOPMD
            				}
            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
    		         	    cell.setBorder(0);
    		                table.addCell(cell);
    		                numdelegadosprival=numdelegadosprival+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	        				numdelegadostotprival=numdelegadostotprival+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            			else{
            				celdaCero(cell,table,fontnormalpeq);
            			}
            		}
            		else{
            			celdaCero(cell,table,fontnormalpeq);
            		}
            		celdaValor(cell,table,String.valueOf(numdelegadospublal+numdelegadosprival),fontnormalpeq);
            		celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublal+numdelegadosprival,ntpa+ntpra),fontnormalpeq);
	                if (c.get("F")!=null){
	            		Map t=(Map)c.get("F");
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA))){
            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
            				}
            				else{
            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA),fontnormalpeq));//NOPMD
            				}
            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
    		         	    cell.setBorder(0);
    		                table.addCell(cell);
    		                numdelegadospublbi=numdelegadospublbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	        				numdelegadostotpublbi=numdelegadostotpublbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			else{
            				celdaCero(cell,table,fontnormalpeq);
            			}            	
            		}
	                else{
	                	celdaCero(cell,table,fontnormalpeq);
	                }
	                if (c.get("L")!=null){
            			Map t=(Map)c.get("L");
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA))){
            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
            				}
            				else{
            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA),fontnormalpeq));//NOPMD
            				}
            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
    		         	    cell.setBorder(0);
    		                table.addCell(cell);
    		                numdelegadosprivbi=numdelegadosprivbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	        				numdelegadostotprivbi=numdelegadostotprivbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			else{
            				celdaCero(cell,table,fontnormalpeq);
            			}
            		}
	                else{
	                	celdaCero(cell,table,fontnormalpeq);
	                }
	                celdaValor(cell,table,String.valueOf(numdelegadospublbi+numdelegadosprivbi),fontnormalpeq);
	                celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublbi+numdelegadosprivbi,ntpb+ntprb),fontnormalpeq);
	                if (c.get("F")!=null){
	            		Map t=(Map)c.get("F");
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA))){
            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
            				}
            				else{
            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA),fontnormalpeq));//NOPMD
            				}	
            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
    		         	    cell.setBorder(0);
    		                table.addCell(cell);
    		                numdelegadospublgi=numdelegadospublgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	        				numdelegadostotpublgi=numdelegadostotpublgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            			else{
            				celdaCero(cell,table,fontnormalpeq);
            			}
	            	}
	                else{
	                	celdaCero(cell,table,fontnormalpeq);
	                }
	                if (c.get("L")!=null){
            			Map t=(Map)c.get("L");
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA))){
            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
            				}
            				else{
            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA),fontnormalpeq));//NOPMD
            				}
            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
    		         	    cell.setBorder(0);
    		                table.addCell(cell);
    		                numdelegadosprivgi=numdelegadosprivgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	        				numdelegadostotprivgi=numdelegadostotprivgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            			else{
            				celdaCero(cell,table,fontnormalpeq);
            			}
            	
            		}
	                else{
	                	celdaCero(cell,table,fontnormalpeq);
	                }
	                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublgi+numdelegadosprivgi),fontnormalpeq);
	                celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublgi+numdelegadosprivgi,ntpg+ntprg),fontnormalpeq);
	            }
	            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublal+numdelegadospublbi+numdelegadospublgi),fontnormalpeq);
	            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadosprival+numdelegadosprivbi+numdelegadosprivgi),fontnormalpeq);
	            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublal+numdelegadospublbi+numdelegadospublgi+numdelegadosprival+numdelegadosprivbi+numdelegadosprivgi),fontnormalpeq);
	            celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublal+numdelegadospublbi+numdelegadospublgi+numdelegadosprival+numdelegadosprivbi+numdelegadosprivgi,nt),fontnormalpeq);
			}		
        }
		if(otros){
			cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
            table.addCell(cell);
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublalpor),fontnormalpeq);
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadosprivalpor),fontnormalpeq);
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublalpor+numdelegadosprivalpor),fontnormalpeq);
            celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublalpor+numdelegadosprivalpor,ntpa+ntpra),fontnormalpeq);               
            
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublbipor),fontnormalpeq);
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadosprivbipor),fontnormalpeq);
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublbipor+numdelegadosprivbipor),fontnormalpeq);
            celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublbipor+numdelegadosprivbipor,ntpb+ntprb),fontnormalpeq);
            
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublgipor),fontnormalpeq);
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadosprivgipor),fontnormalpeq); 
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublgipor+numdelegadosprivgipor),fontnormalpeq);
            celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublgipor+numdelegadosprivgipor,ntpg+ntprg),fontnormalpeq);
            
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublalpor+numdelegadospublbipor+numdelegadospublgipor),fontnormalpeq);
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadosprivalpor+numdelegadosprivbipor+numdelegadosprivgipor),fontnormalpeq);
            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublalpor+numdelegadospublbipor+numdelegadospublgipor+numdelegadosprivalpor+numdelegadosprivbipor+numdelegadosprivgipor),fontnormalpeq);
            celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublalpor+numdelegadospublbipor+numdelegadospublgipor+numdelegadosprivalpor+numdelegadosprivbipor+numdelegadosprivgipor,nt),fontnormalpeq);			
		}
		//total
		cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",idioma).toUpperCase(),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.TOP);
        table.addCell(cell);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublal),fontnormalpeq);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotprival),fontnormalpeq);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublal+numdelegadostotprival),fontnormalpeq);
        celdaValor(cell,table,"",fontnormalpeq);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublbi),fontnormalpeq);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotprivbi),fontnormalpeq);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublbi+numdelegadostotprivbi),fontnormalpeq);
        celdaValor(cell,table,"",fontnormalpeq);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublgi),fontnormalpeq);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotprivgi),fontnormalpeq);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublgi+numdelegadostotprivgi),fontnormalpeq);
        celdaValor(cell,table,"",fontnormalpeq);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublal+numdelegadostotpublgi+numdelegadostotpublbi),fontnormalpeq);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotprival+numdelegadostotprivbi+numdelegadostotprivgi),fontnormalpeq);
        celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublal+numdelegadostotpublgi+numdelegadostotpublbi+numdelegadostotprival+numdelegadostotprivbi+numdelegadostotprivgi),fontnormalpeq);
        celdaValor(cell,table,"",fontnormalpeq);
        try {
			document.add(table);
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void celdaCero(PdfPCell cell, PdfPTable table, Font fontnormalpeq){//NOPMD
		cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
        table.addCell(cell);
	}
	public void celdaValor(PdfPCell cell, PdfPTable table, String valor, Font fontnormalpeq){//NOPMD
		cell=new PdfPCell(new Phrase(valor,fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
        table.addCell(cell);
	}
	public void celdaValorTop(PdfPCell cell, PdfPTable table, String valor, Font fontnormalpeq){//NOPMD
		cell=new PdfPCell(new Phrase(valor,fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.TOP);
 	    cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
        table.addCell(cell);
	}
}

